/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503;

import com.gnr.rtk.addon.epp0503.EPPDefRegBase;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegPeriod;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegRenew;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegRenewReq;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegRenewRsp;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDefRegRenew
extends EPPDefRegBase
implements epp_DefRegRenew {
    private epp_DefRegRenewReq action_request_;
    private epp_DefRegRenewRsp action_response_;

    public EPPDefRegRenew() {
    }

    public EPPDefRegRenew(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDefRegRenew(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_DefRegRenewReq value) {
        this.action_request_ = value;
    }

    public epp_DefRegRenewRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_roid == null) {
            throw new epp_XMLException("missing request data or DefReg roid");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element renew = doc.createElement("renew");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element DefReg_renew = doc.createElement("defReg:renew");
        this.setCommonAttributes(DefReg_renew);
        this.addXMLElement((Document)doc, DefReg_renew, "defReg:roid", this.action_request_.m_roid);
        this.addXMLElement((Document)doc, DefReg_renew, "defReg:curExpDate", this.action_request_.m_current_expiration_date);
        if (this.action_request_.m_period != null) {
            epp_DefRegPeriod DefReg_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, DefReg_renew, "defReg:period", Short.toString(DefReg_period.m_value));
            period.setAttribute("unit", period_unit_to_string_array_[DefReg_period.m_unit.value()]);
        }
        renew.appendChild(DefReg_renew);
        command.appendChild(renew);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DefRegRenewRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList DefReg_create_data_list = response_data_element.getElementsByTagName("defReg:creData").item(0).getChildNodes();
            this.debug(2, method_name, "defReg:creData's node count [" + DefReg_create_data_list.getLength() + "]");
            if (DefReg_create_data_list == null || DefReg_create_data_list.getLength() == 0) {
                throw new epp_XMLException("missing defreg create response data");
            }
            for (int count = 0; count < DefReg_create_data_list.getLength(); ++count) {
                Node a_node = DefReg_create_data_list.item(count);
                if (a_node.getNodeName().equals("defReg:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("defReg:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

