/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503;

import com.gnr.rtk.addon.epp0503.EPPDefRegBase;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegPeriod;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegTransfer;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegTransferReq;
import com.gnr.rtk.addon.epp0503.idl.defreg.epp_DefRegTransferRsp;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_TransferOpType;
import org.openrtk.idl.epp0503.epp_TransferRequest;
import org.openrtk.idl.epp0503.epp_TransferStatusType;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDefRegTransfer
extends EPPDefRegBase
implements epp_DefRegTransfer {
    private epp_DefRegTransferReq action_request_;
    private epp_DefRegTransferRsp action_response_;

    public EPPDefRegTransfer() {
    }

    public EPPDefRegTransfer(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDefRegTransfer(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_DefRegTransferReq value) {
        this.action_request_ = value;
    }

    public epp_DefRegTransferRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "toXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_trans == null || this.action_request_.m_roid == null) {
            throw new epp_XMLException("missing request data or defreg roid");
        }
        epp_Command command_data = this.action_request_.m_cmd;
        epp_TransferRequest transfer_request_data = this.action_request_.m_trans;
        if (transfer_request_data.m_op == null) {
            this.debug(2, method_name, "transfer op is null, so assuming query");
            transfer_request_data.m_op = epp_TransferOpType.QUERY;
        } else if (transfer_request_data.m_op.value() >= transfer_op_to_string_array_.length) {
            throw new epp_XMLException("invalid transfer op value");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element transfer = doc.createElement("transfer");
        transfer.setAttribute("op", transfer_op_to_string_array_[transfer_request_data.m_op.value()]);
        Element DefReg_transfer = doc.createElement("defReg:transfer");
        this.setCommonAttributes(DefReg_transfer);
        this.addXMLElement((Document)doc, DefReg_transfer, "defReg:roid", this.action_request_.m_roid);
        if (this.action_request_.m_period != null) {
            epp_DefRegPeriod DefReg_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, DefReg_transfer, "defReg:period", Short.toString(DefReg_period.m_value));
            period.setAttribute("unit", period_unit_to_string_array_[DefReg_period.m_unit.value()]);
        }
        transfer.appendChild(DefReg_transfer);
        if (transfer_request_data.m_auth_info != null) {
            DefReg_transfer.appendChild(this.prepareAuthInfo((Document)doc, "defReg:authInfo", transfer_request_data.m_auth_info));
        } else if (transfer_request_data.m_op == epp_TransferOpType.REQUEST) {
            throw new epp_XMLException("missing request auth id");
        }
        command.appendChild(transfer);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DefRegTransferRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList DefReg_transfer_data_list = response_data_element.getElementsByTagName("defReg:trnData").item(0).getChildNodes();
            this.debug(2, method_name, "defReg:trnData's node count [" + DefReg_transfer_data_list.getLength() + "]");
            if (DefReg_transfer_data_list.getLength() == 0) {
                throw new epp_XMLException("missing defreg transfer data");
            }
            for (int count = 0; count < DefReg_transfer_data_list.getLength(); ++count) {
                Node a_node = DefReg_transfer_data_list.item(count);
                if (a_node.getNodeName().equals("defReg:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:reID")) {
                    this.action_response_.m_request_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:acID")) {
                    this.action_response_.m_action_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:trStatus")) {
                    String status_value = a_node.getFirstChild().getNodeValue();
                    if (!transfer_status_to_type_hash_.containsKey(status_value)) {
                        throw new epp_XMLException("unknown returned transfer status [" + status_value + "]");
                    }
                    this.action_response_.m_transfer_status = (epp_TransferStatusType)transfer_status_to_type_hash_.get(status_value);
                }
                if (a_node.getNodeName().equals("defReg:reDate")) {
                    this.action_response_.m_request_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:acDate")) {
                    this.action_response_.m_action_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("defReg:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

