/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503;

import com.gnr.rtk.addon.epp0503.EPPEmailFwdBase;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContact;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdCreate;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdCreateReq;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdCreateRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdPeriod;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPEmailFwdCreate
extends EPPEmailFwdBase
implements epp_EmailFwdCreate {
    private epp_EmailFwdCreateReq action_request_;
    private epp_EmailFwdCreateRsp action_response_;

    public EPPEmailFwdCreate() {
    }

    public EPPEmailFwdCreate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPEmailFwdCreate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_EmailFwdCreateReq value) {
        this.action_request_ = value;
    }

    public epp_EmailFwdCreateRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML(EPPTransID)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or emailfwd name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element create = doc.createElement("create");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element emailfwd_create = doc.createElement("emailFwd:create");
        this.setCommonAttributes(emailfwd_create);
        this.addXMLElement((Document)doc, emailfwd_create, "emailFwd:name", this.action_request_.m_name);
        if (this.action_request_.m_fwdto != null) {
            this.addXMLElement((Document)doc, emailfwd_create, "emailFwd:fwdTo", this.action_request_.m_fwdto);
        }
        if (this.action_request_.m_period != null) {
            epp_EmailFwdPeriod emailfwd_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, emailfwd_create, "emailFwd:period", Short.toString(emailfwd_period.m_value));
            period.setAttribute("unit", period_unit_to_string_array_[emailfwd_period.m_unit.value()]);
        }
        if (this.action_request_.m_registrant != null) {
            this.addXMLElement((Document)doc, emailfwd_create, "emailFwd:registrant", this.action_request_.m_registrant);
        }
        if (this.action_request_.m_contacts != null && this.action_request_.m_contacts.length > 0) {
            List<epp_EmailFwdContact> contacts = Arrays.asList(this.action_request_.m_contacts);
            Iterator<epp_EmailFwdContact> it = contacts.iterator();
            while (it.hasNext()) {
                epp_EmailFwdContact emailfwd_contact = it.next();
                Element contact_element = this.addXMLElement((Document)doc, emailfwd_create, "emailFwd:contact", emailfwd_contact.m_id);
                contact_element.setAttribute("type", contact_type_to_string_array_[emailfwd_contact.m_type.value()]);
            }
        }
        if (this.action_request_.m_auth_info == null) {
            throw new epp_XMLException("missing auth info");
        }
        emailfwd_create.appendChild(this.prepareAuthInfo((Document)doc, "emailFwd:authInfo", this.action_request_.m_auth_info));
        create.appendChild(emailfwd_create);
        command.appendChild(create);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_EmailFwdCreateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList emailfwd_create_data_list = response_data_element.getElementsByTagName("emailFwd:creData").item(0).getChildNodes();
            this.debug(2, method_name, "emailFwd:creData's node count [" + emailfwd_create_data_list.getLength() + "]");
            if (emailfwd_create_data_list == null || emailfwd_create_data_list.getLength() == 0) {
                throw new epp_XMLException("missing emailfwd create response data");
            }
            for (int count = 0; count < emailfwd_create_data_list.getLength(); ++count) {
                Node a_node = emailfwd_create_data_list.item(count);
                if (a_node.getNodeName().equals("emailFwd:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:crDate")) {
                    this.action_response_.m_creation_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("emailFwd:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

