/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503;

import com.gnr.rtk.addon.epp0503.EPPNamewatchBase;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchInfo;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchInfoReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchInfoRsp;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchRptTo;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchStatus;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchStatusType;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp0503.epp_AuthInfo;
import org.openrtk.idl.epp0503.epp_AuthInfoType;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPNamewatchInfo
extends EPPNamewatchBase
implements epp_NamewatchInfo {
    private epp_NamewatchInfoReq action_request_;
    private epp_NamewatchInfoRsp action_response_;

    public EPPNamewatchInfo() {
    }

    public EPPNamewatchInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPNamewatchInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_NamewatchInfoReq value) {
        this.action_request_ = value;
    }

    public epp_NamewatchInfoRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_roid == null) {
            throw new epp_XMLException("missing request data or Namewatch name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element Namewatch_info = doc.createElement("nameWatch:info");
        this.setCommonAttributes(Namewatch_info);
        this.addXMLElement((Document)doc, Namewatch_info, "nameWatch:roid", this.action_request_.m_roid);
        info.appendChild(Namewatch_info);
        command.appendChild(info);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_NamewatchInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList Namewatch_info_result_list = response_data_element.getElementsByTagName("nameWatch:infData").item(0).getChildNodes();
            this.debug(2, method_name, "nameWatch:infData's node count [" + Namewatch_info_result_list.getLength() + "]");
            if (Namewatch_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_NamewatchStatus> statuses = new ArrayList<epp_NamewatchStatus>();
            ArrayList contacts = new ArrayList();
            ArrayList name_servers = new ArrayList();
            ArrayList hosts = new ArrayList();
            for (int count = 0; count < Namewatch_info_result_list.getLength(); ++count) {
                Node a_node = Namewatch_info_result_list.item(count);
                if (a_node.getNodeName().equals("nameWatch:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:registrant")) {
                    this.action_response_.m_registrant = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:rptTo")) {
                    this.action_response_.m_rptto = new epp_NamewatchRptTo();
                    this.action_response_.m_rptto.m_email = a_node.getFirstChild().getNodeValue();
                    this.action_response_.m_rptto.m_freq = EPPNamewatchInfo.namewatchFreqFromString(((Element)a_node).getAttribute("freq"));
                }
                if (a_node.getNodeName().equals("nameWatch:status")) {
                    epp_NamewatchStatus status = new epp_NamewatchStatus();
                    Node status_value_node = a_node.getFirstChild();
                    if (status_value_node != null) {
                        status.m_value = status_value_node.getNodeValue();
                    }
                    status.m_lang = ((Element)a_node).getAttribute("lang");
                    if (!namewatch_status_hash_.containsKey(((Element)a_node).getAttribute("s"))) {
                        status.m_value = "invalid Namewatch status from server";
                        status.m_lang = "en";
                        status.m_type = null;
                    } else {
                        status.m_type = (epp_NamewatchStatusType)namewatch_status_hash_.get(((Element)a_node).getAttribute("s"));
                    }
                    statuses.add(status);
                }
                if (a_node.getNodeName().equals("nameWatch:clID")) {
                    this.action_response_.m_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:trDate")) {
                    this.action_response_.m_transfer_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("nameWatch:exDate")) {
                    this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("nameWatch:authInfo")) continue;
                this.action_response_.m_auth_info = new epp_AuthInfo();
                this.action_response_.m_auth_info.m_value = a_node.getFirstChild().getNodeValue();
                this.action_response_.m_auth_info.m_type = (epp_AuthInfoType)auth_type_string_to_type_hash_.get(((Element)a_node).getAttribute("type"));
                this.action_response_.m_auth_info.m_roid = ((Element)a_node).getAttribute("roid");
            }
            if (statuses.size() > 0) {
                this.action_response_.m_status = (epp_NamewatchStatus[])EPPNamewatchInfo.convertListToArray(new epp_NamewatchStatus().getClass(), statuses);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

