/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503.example;

import com.gnr.rtk.addon.epp0503.example.EmailFwdExampleBase;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContact;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContactType;
import com.tucows.oxrs.epp0503.rtk.RTKBase;
import com.tucows.oxrs.epp0503.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epp0503.rtk.xml.EPPXMLBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.openrtk.idl.epp0503.domain.epp_DomainContact;
import org.openrtk.idl.epp0503.domain.epp_DomainContactType;
import org.openrtk.idl.epp0503.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp0503.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epp0503.domain.epp_DomainPeriod;
import org.openrtk.idl.epp0503.domain.epp_DomainPeriodUnitType;
import org.openrtk.idl.epp0503.epp_Action;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_Response;
import org.openrtk.idl.epp0503.epp_Result;
import org.openrtk.idl.epp0503.epp_XMLException;

public class EmailFwdBatchExample
extends EmailFwdExampleBase {
    private static String USAGE = "Usage: com.gnr.rtk.addon.epp0503.example.EmailFwdBatchExample epp_host_name epp_host_port epp_client_id epp_password landrush_file";

    private static epp_DomainPeriod createDomainPeriod(int period) {
        epp_DomainPeriod p = new epp_DomainPeriod();
        p.m_unit = epp_DomainPeriodUnitType.YEAR;
        p.m_value = (short)period;
        return p;
    }

    private static epp_DomainCreateRsp domainCreate(String epp_client_id, String name, int period, String[] nameservers, String registrant, epp_DomainContact[] contacts, String password) {
        System.out.println("DOMAIN_CREATE: begin");
        epp_DomainCreateReq create_request = new epp_DomainCreateReq();
        create_request.m_cmd = EmailFwdBatchExample.createCommand(epp_client_id);
        create_request.m_name = name;
        create_request.m_period = EmailFwdBatchExample.createDomainPeriod(period);
        create_request.m_name_servers = nameservers;
        create_request.m_registrant = registrant;
        create_request.m_contacts = contacts;
        create_request.m_auth_info = EmailFwdBatchExample.createPwAuthInfo(password);
        System.out.println("DOMAIN_CREATE: Sending registration for " + name);
        EPPDomainCreate create = new EPPDomainCreate();
        create.setRequestData(create_request);
        epp_DomainCreateRsp create_response = null;
        epp_Response response = null;
        try {
            create = (EPPDomainCreate)epp_client.processAction((epp_Action)create);
            create_response = create.getResponseData();
            if (create_response != null) {
                response = create_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (create_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return null;
        }
        return create_response;
    }

    public static void main(String[] args) {
        Object command_data = null;
        Object domain_auth_info = null;
        Object namewatch_exp_date = null;
        if (args.length < 5) {
            System.err.println(USAGE);
            System.exit(1);
        }
        RTKBase.setDebugLevel();
        String epp_host_name = args[0];
        String epp_host_port_string = args[1];
        String epp_client_id = args[2];
        String epp_password = args[3];
        String namewatch_file = args[4];
        if (!EmailFwdBatchExample.connect(epp_host_name, epp_host_port_string, epp_client_id, epp_password)) {
            System.err.println("Unable to connect to EPP server. Exiting");
            System.exit(1);
        }
        try {
            File inputFile = new File(namewatch_file);
            BufferedReader inf = new BufferedReader(new FileReader(inputFile));
            File outputFile = new File(namewatch_file + ".result");
            PrintWriter outf = new PrintWriter(new FileWriter(outputFile));
            String buf = inf.readLine();
            System.out.println("Banner: '" + buf + "'");
            StreamTokenizer st = new StreamTokenizer(inf);
            st.quoteChar(34);
            st.eolIsSignificant(true);
            while (st.nextToken() != -1) {
                epp_Result[] results;
                Object create_response;
                Object[] contacts;
                String transaction_id = st.sval;
                st.nextToken();
                String auth_info = st.sval;
                st.nextToken();
                String domainname = st.sval;
                st.nextToken();
                String dperiod = st.sval;
                st.nextToken();
                String emailfwd = st.sval;
                st.nextToken();
                String eperiod = st.sval;
                st.nextToken();
                String registrant = st.sval;
                st.nextToken();
                String admin = st.sval;
                st.nextToken();
                String tech = st.sval;
                st.nextToken();
                String billing = st.sval;
                st.nextToken();
                String fwdto = st.sval;
                ArrayList<String> hosts = new ArrayList<String>();
                int count = 0;
                while (st.nextToken() != 10) {
                    hosts.add(st.sval);
                    ++count;
                }
                if (count > 13) {
                    System.err.println("ERROR: Trying to add more than 13 nameservers at line " + st.lineno());
                }
                String resultcode = "";
                String description = "";
                String creation_date = "0000-00-00";
                String expiration_date = "0000-00-00";
                if (domainname != null && domainname != "") {
                    contacts = new epp_DomainContact[3];
                    contacts[0] = new epp_DomainContact();
                    contacts[0].m_id = admin;
                    contacts[0].m_type = epp_DomainContactType.ADMIN;
                    contacts[1] = new epp_DomainContact();
                    contacts[1].m_id = tech;
                    contacts[1].m_type = epp_DomainContactType.TECH;
                    contacts[2] = new epp_DomainContact();
                    contacts[2].m_id = billing;
                    contacts[2].m_type = epp_DomainContactType.BILLING;
                    create_response = EmailFwdBatchExample.domainCreate(epp_client_id, domainname, Integer.parseInt(dperiod), EPPXMLBase.convertListToStringArray(hosts), registrant, contacts, auth_info);
                    if (create_response != null) {
                        results = create_response.m_rsp.m_results;
                        resultcode = Integer.toString(results[0].m_code);
                        description = results[0].m_msg;
                        if (create_response.m_creation_date != null) {
                            creation_date = create_response.m_creation_date.substring(0, 10);
                        }
                        if (create_response.m_expiration_date != null) {
                            expiration_date = create_response.m_expiration_date.substring(0, 10);
                        }
                    } else {
                        System.err.println("ERROR: null response from emailfwdCreate");
                    }
                }
                if ((resultcode.equals("") || resultcode.equals("1000")) && emailfwd != null && !emailfwd.equals("")) {
                    contacts = new epp_EmailFwdContact[3];
                    contacts[0] = new epp_EmailFwdContact();
                    contacts[0].m_id = admin;
                    contacts[0].m_type = epp_EmailFwdContactType.ADMIN;
                    contacts[1] = new epp_EmailFwdContact();
                    contacts[1].m_id = tech;
                    contacts[1].m_type = epp_EmailFwdContactType.TECH;
                    contacts[2] = new epp_EmailFwdContact();
                    contacts[2].m_id = billing;
                    contacts[2].m_type = epp_EmailFwdContactType.BILLING;
                    create_response = EmailFwdBatchExample.emailfwdCreate(epp_client_id, emailfwd, fwdto, Integer.parseInt(eperiod), registrant, (epp_EmailFwdContact[])contacts, auth_info);
                    if (create_response != null) {
                        results = create_response.m_rsp.m_results;
                        resultcode = Integer.toString(results[0].m_code);
                        description = description.equals("") ? results[0].m_msg : description + " -- " + results[0].m_msg;
                        if (create_response.m_creation_date != null) {
                            creation_date = create_response.m_creation_date.substring(0, 10);
                        }
                        if (create_response.m_expiration_date != null) {
                            expiration_date = create_response.m_expiration_date.substring(0, 10);
                        }
                    } else {
                        System.err.println("ERROR: null response from emailfwdCreate");
                    }
                }
                outf.println("\"" + resultcode + "\" \"" + domainname + "\" \"" + emailfwd + "\" \"" + registrant + "\" \"" + registrant + "\" \"" + transaction_id + "\" \"" + creation_date + "\" \"" + expiration_date + "\" \"" + description + "\"");
            }
            inf.close();
            outf.close();
        }
        catch (IOException io) {
            System.err.println("Error occured during processing. Aborting");
            System.err.println(io);
            EmailFwdBatchExample.disconnect(epp_client_id);
            System.exit(1);
        }
        if (!EmailFwdBatchExample.disconnect(epp_client_id)) {
            System.err.println("Error during disconnect from EPP server. Exiting");
            System.exit(1);
        }
    }
}

