/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503.example;

import com.gnr.rtk.addon.epp0503.EPPEmailFwdBase;
import com.gnr.rtk.addon.epp0503.example.ContactExampleBase;
import com.gnr.rtk.addon.epp0503.example.EmailFwdExampleBase;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContact;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContactType;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdCreateRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdDeleteRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdInfoRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdRenewRsp;
import com.tucows.oxrs.epp0503.rtk.RTKBase;
import org.openrtk.idl.epp0503.contact.epp_ContactAddress;
import org.openrtk.idl.epp0503.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epp0503.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0503.contact.epp_ContactPhone;
import org.openrtk.idl.epp0503.epp_Result;

public class EmailFwdExample
extends EmailFwdExampleBase {
    private static String USAGE = "Usage: com.gnr.rtk.addon.epp0503.example.EmailFwdExample epp_host_name epp_host_port epp_client_id epp_password emailfwd_string";

    private static void emailfwdCreateTest(String epp_client_id, String name, String fwdto, int period, String registrant, epp_EmailFwdContact[] contacts, String password) {
        epp_EmailFwdCreateRsp rsp = EmailFwdExample.emailfwdCreate(epp_client_id, name, fwdto, period, registrant, contacts, password);
        if (rsp == null) {
            System.out.println("EMAILFWD_CREATE: NO RESPONSE FOUND");
            return;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_CREATE: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("EMAILFWD_CREATE: name=[" + rsp.m_name + "]");
    }

    private static void emailfwdRenewTest(String epp_client_id, String name, String expirydate, int period) {
        epp_EmailFwdRenewRsp rsp = EmailFwdExample.emailfwdRenew(epp_client_id, name, expirydate, period);
        if (rsp == null) {
            System.out.println("EMAILFWD_RENEW: NO RESPONSE FOUND");
            return;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_RENEW: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("EMAILFWD_RENEW: name=[" + rsp.m_name + "]");
    }

    private static void emailfwdDeleteTest(String epp_client_id, String name) {
        epp_EmailFwdDeleteRsp rsp = EmailFwdExample.emailfwdDelete(epp_client_id, name);
        if (rsp == null) {
            System.out.println("EMAILFWD_DELETE: NO RESPONSE FOUND");
            return;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_DELETE: code=[" + results[0].m_code + "] msg=[" + results[0].m_msg + "]");
    }

    private static epp_EmailFwdInfoRsp emailfwdInfoTest(String epp_client_id, String name) {
        int i;
        epp_EmailFwdInfoRsp rsp = EmailFwdExample.emailfwdInfo(epp_client_id, name);
        if (rsp == null) {
            System.out.println("EMAILFWD_INFO: NO RESPONSE FOUND");
            return null;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_INFO: code=[" + results[0].m_code + "] msg=[" + results[0].m_msg + "]");
        System.out.println("EMAILFWD_INFO: name=[" + rsp.m_name + "]");
        System.out.println("EMAILFWD_INFO: roid=[" + rsp.m_roid + "]");
        System.out.println("EMAILFWD_INFO: status {");
        for (i = 0; i < rsp.m_status.length; ++i) {
            System.out.println("EMAILFWD_INFO:   type=[" + EPPEmailFwdBase.emailfwdStatusToString(rsp.m_status[i].m_type) + "]");
            System.out.println("EMAILFWD_INFO:   lang=[" + rsp.m_status[i].m_lang + "]");
            System.out.println("EMAILFWD_INFO:   value=[" + rsp.m_status[i].m_value + "]");
        }
        System.out.println("EMAILFWD_INFO: }");
        System.out.println("EMAILFWD_INFO: registrant=[" + rsp.m_registrant + "]");
        System.out.println("EMAILFWD_INFO: contacts {");
        for (i = 0; i < rsp.m_contacts.length; ++i) {
            System.out.println("EMAILFWD_INFO:   type=[" + EPPEmailFwdBase.emailfwdContactTypeToString(rsp.m_contacts[i].m_type) + "]");
            System.out.println("EMAILFWD_INFO:   id=[" + rsp.m_contacts[i].m_id + "]");
        }
        System.out.println("EMAILFWD_INFO: }");
        System.out.println("EMAILFWD_INFO: fwd_to=[" + rsp.m_fwdto + "]");
        System.out.println("EMAILFWD_INFO: client_id=[" + rsp.m_client_id + "]");
        System.out.println("EMAILFWD_INFO: created_by=[" + rsp.m_created_by + "]");
        System.out.println("EMAILFWD_INFO: created_date=[" + rsp.m_created_date + "]");
        System.out.println("EMAILFWD_INFO: updated_by=[" + rsp.m_updated_by + "]");
        System.out.println("EMAILFWD_INFO: updated_date=[" + rsp.m_updated_date + "]");
        System.out.println("EMAILFWD_INFO: expiration_date=[" + rsp.m_expiration_date + "]");
        System.out.println("EMAILFWD_INFO: transfer_date=[" + rsp.m_transfer_date + "]");
        return rsp;
    }

    public static void main(String[] args) {
        System.out.println("Start of the EmailFwd example");
        Object command_data = null;
        Object auth_info = null;
        Object exp_date = null;
        if (args.length < 5) {
            System.err.println(USAGE);
            System.exit(1);
        }
        RTKBase.setDebugLevel();
        String epp_host_name = args[0];
        String epp_host_port_string = args[1];
        String epp_client_id = args[2];
        String epp_password = args[3];
        String emailfwd = args[4];
        System.out.println("WARNING: Most of the tests marked [SHOULD_FAIL] will succeed in the .name OT&E playground, as the");
        System.out.println("         playground environment does not keep state of objects and only return example responses");
        System.out.println("         based on the data passed. The tests should give the expected result in the OT&E certification");
        System.out.println("         environment available from April 15th");
        if (!EmailFwdExample.connect(epp_host_name, epp_host_port_string, epp_client_id, epp_password)) {
            System.err.println("Unable to connect to EPP server. Exiting");
            System.exit(1);
        }
        epp_ContactCreateRsp admin = null;
        epp_ContactCreateRsp tech = null;
        epp_ContactCreateRsp billing = null;
        epp_ContactCreateRsp registrant = null;
        epp_ContactNameAddress addr = null;
        addr = new epp_ContactNameAddress();
        addr.m_name = "Mr Registrant";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "High Street 57";
        addr.m_address.m_city = "Funnytown";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "fr";
        registrant = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("123", "+44.12345678"), new epp_ContactPhone(null, "+44.87654321"), "mycontactemail@somedomain.domain", "password");
        if (registrant != null) {
            System.out.println("Contact create (registrant): " + registrant.m_rsp.m_results[0].m_code);
        }
        addr = new epp_ContactNameAddress();
        addr.m_name = "John Doe";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "High Street 57";
        addr.m_address.m_city = "Funnytown";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "ch";
        admin = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("123", "+44.12345678"), new epp_ContactPhone(null, "+44.87654321"), "mycontactemail@somedomain.domain", "password");
        if (admin != null) {
            System.out.println("Contact create (admin): " + admin.m_rsp.m_results[0].m_code);
        }
        addr = new epp_ContactNameAddress();
        addr.m_name = "Foo Bar";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "High Street 55b";
        addr.m_address.m_city = "London";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "gb";
        tech = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("55", "+66.12345678"), new epp_ContactPhone(null, "+77.87654321"), "someother@somedomain.domain", "foobar");
        if (tech != null) {
            System.out.println("Contact create (tech): " + tech.m_rsp.m_results[0].m_code);
        }
        addr = new epp_ContactNameAddress();
        addr.m_name = "Iam A Bigshot";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "Nowhere in particular";
        addr.m_address.m_city = "Outoftown";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "se";
        billing = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("22", "+55.55555555"), new epp_ContactPhone(null, "+22.22222222"), "email@somedomain.domain", "test");
        if (billing != null) {
            System.out.println("Contact create (billing): " + billing.m_rsp.m_results[0].m_code);
        }
        epp_EmailFwdContact[] contacts = new epp_EmailFwdContact[3];
        contacts[0] = new epp_EmailFwdContact();
        contacts[0].m_id = admin != null ? admin.m_id : "PHB";
        contacts[0].m_type = epp_EmailFwdContactType.ADMIN;
        contacts[1] = new epp_EmailFwdContact();
        contacts[1].m_id = tech != null ? tech.m_id : "GURU";
        contacts[1].m_type = epp_EmailFwdContactType.TECH;
        contacts[2] = new epp_EmailFwdContact();
        contacts[2].m_id = billing != null ? billing.m_id : "BEANCOUNTER";
        contacts[2].m_type = epp_EmailFwdContactType.BILLING;
        String registrant_id = registrant != null ? registrant.m_id : "MYCONTACTID-NAME";
        epp_EmailFwdInfoRsp info = null;
        EmailFwdExample.testHeader(1, true, "Create email forwarding object for 5 years");
        EmailFwdExample.emailfwdCreateTest(epp_client_id, emailfwd, "mymailbox@mailboxes-r-us.mail", 5, registrant_id, contacts, "password");
        EmailFwdExample.testHeader(2, false, "Create email forwarding object with same name (should fail)");
        EmailFwdExample.emailfwdCreateTest(epp_client_id, emailfwd, "mymailbox@mailboxes-r-us.mail", 5, registrant_id, contacts, "password");
        EmailFwdExample.testHeader(3, true, "Request information about email forwarding object");
        info = EmailFwdExample.emailfwdInfoTest(epp_client_id, emailfwd);
        EmailFwdExample.testHeader(4, true, "Renew e-mail forwarding for 1 year (expiration should now be 6 years in ahead if test 1 succeeded)");
        EmailFwdExample.emailfwdRenewTest(epp_client_id, emailfwd, info.m_expiration_date, 1);
        EmailFwdExample.testHeader(5, true, "Request information about email forwarding object to check new expiration date");
        EmailFwdExample.emailfwdInfoTest(epp_client_id, emailfwd);
        EmailFwdExample.testHeader(6, true, "Delete email forwarding object");
        EmailFwdExample.emailfwdDeleteTest(epp_client_id, emailfwd);
        EmailFwdExample.testHeader(7, false, "Delete already deleted object");
        EmailFwdExample.emailfwdDeleteTest(epp_client_id, emailfwd);
        if (!EmailFwdExample.disconnect(epp_client_id)) {
            System.err.println("Error during disconnect from EPP server. Exiting");
            System.exit(1);
        }
    }
}

