/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503.example;

import com.tucows.oxrs.epp0503.rtk.EPPClient;
import org.openrtk.idl.epp0503.epp_Action;
import org.openrtk.idl.epp0503.epp_AuthInfo;
import org.openrtk.idl.epp0503.epp_AuthInfoType;
import org.openrtk.idl.epp0503.epp_Command;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_Greeting;
import org.openrtk.idl.epp0503.epp_Result;
import org.openrtk.idl.epp0503.epp_XMLException;

public class ExampleBase {
    protected static EPPClient epp_client;

    public static void testHeader(int number, boolean succeed, String descr) {
        String succ = succeed ? "SHOULD_SUCCEED" : "SHOULD_FAIL";
        System.out.println("--- TEST " + number + " [" + succ + "]: " + descr);
    }

    protected static epp_AuthInfo createPwAuthInfo(String password) {
        epp_AuthInfo auth_info = null;
        if (password != null && password != "") {
            auth_info = new epp_AuthInfo();
            auth_info.m_value = password;
            auth_info.m_type = epp_AuthInfoType.PW;
        }
        return auth_info;
    }

    protected static epp_Command createCommand(String epp_client_id) {
        epp_Command command_data = new epp_Command();
        command_data.m_client_trid = ExampleBase.getClientTrid(epp_client_id);
        return command_data;
    }

    protected static String getClientTrid(String epp_client_id) {
        return "ABC:" + epp_client_id + ":" + System.currentTimeMillis();
    }

    protected static boolean connect(String epp_host_name, String epp_host_port_string, String epp_client_id, String epp_password) {
        int epp_host_port = Integer.parseInt(epp_host_port_string);
        epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
        try {
            epp_client.setLang("en");
            System.out.println("CONNECT: Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("CONNECT: greeting.m_server_id [" + greeting.m_server_id + "]");
            System.out.println("CONNECT: greeting.m_server_date [" + greeting.m_server_date + "]");
            String client_trid = ExampleBase.getClientTrid(epp_client_id);
            System.out.println("CONNECT: Logging into the EPP Server");
            epp_client.login(client_trid);
            return true;
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        return false;
    }

    protected static boolean disconnect(String epp_client_id) {
        try {
            System.out.println("DISCONNECT: Logging out from the EPP Server");
            epp_client.logout(ExampleBase.getClientTrid(epp_client_id));
            System.out.println("DISCONNECT: Disconnecting from the EPP Server");
            epp_client.disconnect();
            return true;
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        return false;
    }

    protected static epp_Action processAction(epp_Action action) {
        try {
            epp_Action rsp = epp_client.processAction(action);
            return rsp;
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        return null;
    }
}

