/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503.example;

import com.gnr.rtk.addon.epp0503.EPPNamewatchBase;
import com.gnr.rtk.addon.epp0503.EPPNamewatchCreate;
import com.gnr.rtk.addon.epp0503.EPPNamewatchDelete;
import com.gnr.rtk.addon.epp0503.EPPNamewatchInfo;
import com.gnr.rtk.addon.epp0503.EPPNamewatchRenew;
import com.gnr.rtk.addon.epp0503.EPPNamewatchTransfer;
import com.gnr.rtk.addon.epp0503.EPPNamewatchUpdate;
import com.gnr.rtk.addon.epp0503.example.ExampleBase;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchCreateReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchCreateRsp;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchDeleteReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchDeleteRsp;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchInfoReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchInfoRsp;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchPeriod;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchPeriodUnitType;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchRenewReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchRenewRsp;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchRptTo;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchStatus;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchTransferReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchTransferRsp;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchUpdateAddRemove;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchUpdateChange;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchUpdateReq;
import com.gnr.rtk.addon.epp0503.idl.namewatch.epp_NamewatchUpdateRsp;
import com.tucows.oxrs.epp0503.rtk.RTKBase;
import com.tucows.oxrs.epp0503.rtk.xml.EPPXMLBase;
import org.openrtk.idl.epp0503.epp_Action;
import org.openrtk.idl.epp0503.epp_Exception;
import org.openrtk.idl.epp0503.epp_Response;
import org.openrtk.idl.epp0503.epp_Result;
import org.openrtk.idl.epp0503.epp_TransferOpType;
import org.openrtk.idl.epp0503.epp_TransferRequest;
import org.openrtk.idl.epp0503.epp_TransferStatusType;
import org.openrtk.idl.epp0503.epp_XMLException;

public class NamewatchExample
extends ExampleBase {
    private static String USAGE = "Usage: com.gnr.rtk.addon.epp0503.example.NamewatchExample epp_host_name epp_host_port epp_client_id epp_password epp_namewatch_string";

    private static epp_NamewatchPeriod createNamewatchPeriod(int period) {
        epp_NamewatchPeriod p = new epp_NamewatchPeriod();
        p.m_unit = epp_NamewatchPeriodUnitType.YEAR;
        p.m_value = (short)period;
        return p;
    }

    private static String namewatchCreate(String epp_client_id, String namewatch_string, String registrant, String rptto, String frequency, int period, String password) {
        System.out.println("NAMEWATCH_CREATE: begin");
        epp_NamewatchCreateReq create_request = new epp_NamewatchCreateReq();
        create_request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        create_request.m_name = namewatch_string;
        create_request.m_registrant = registrant;
        create_request.m_rptto = new epp_NamewatchRptTo(rptto, EPPNamewatchBase.namewatchFreqFromString(frequency));
        create_request.m_period = NamewatchExample.createNamewatchPeriod(period);
        create_request.m_auth_info = NamewatchExample.createPwAuthInfo(password);
        System.out.println("NAMEWATCH_CREATE: Sending registration");
        EPPNamewatchCreate namewatch_create = new EPPNamewatchCreate();
        namewatch_create.setRequestData(create_request);
        epp_NamewatchCreateRsp create_response = null;
        epp_Response response = null;
        try {
            namewatch_create = (EPPNamewatchCreate)epp_client.processAction((epp_Action)namewatch_create);
            create_response = namewatch_create.getResponseData();
            if (create_response != null) {
                response = create_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (create_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return "";
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_CREATE: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_CREATE: name=[" + create_response.m_name + "]");
        System.out.println("NAMEWATCH_CREATE: roid=[" + create_response.m_roid + "]");
        System.out.println("NAMEWATCH_CREATE: end.");
        return create_response.m_roid;
    }

    private static void namewatchRenew(String epp_client_id, String roid, String expirydate, int period) {
        System.out.println("NAMEWATCH_RENEW: begin");
        epp_NamewatchRenewReq request = new epp_NamewatchRenewReq();
        request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        request.m_roid = roid;
        request.m_current_expiration_date = expirydate;
        request.m_period = NamewatchExample.createNamewatchPeriod(period);
        System.out.println("NAMEWATCH_RENEW: Sending request");
        EPPNamewatchRenew command = new EPPNamewatchRenew();
        command.setRequestData(request);
        epp_NamewatchRenewRsp request_response = null;
        epp_Response response = null;
        try {
            command = (EPPNamewatchRenew)epp_client.processAction((epp_Action)command);
            request_response = command.getResponseData();
            if (request_response != null) {
                response = request_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (request_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return;
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_RENEW: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_RENEW: m_roid=[" + request_response.m_roid + "]");
        System.out.println("NAMEWATCH_RENEW: m_expiration_date=[" + request_response.m_expiration_date + "]");
        System.out.println("NAMEWATCH_RENEW: end.");
    }

    private static epp_NamewatchInfoRsp namewatchInfo(String epp_client_id, String roid) {
        System.out.println("NAMEWATCH_INFO: begin");
        epp_NamewatchInfoReq info_request = new epp_NamewatchInfoReq();
        info_request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        info_request.m_roid = roid;
        System.out.println("NAMEWATCH_INFO: Sending request");
        EPPNamewatchInfo namewatch_info = new EPPNamewatchInfo();
        namewatch_info.setRequestData(info_request);
        epp_NamewatchInfoRsp info_response = null;
        epp_Response response = null;
        try {
            namewatch_info = (EPPNamewatchInfo)epp_client.processAction((epp_Action)namewatch_info);
            info_response = namewatch_info.getResponseData();
            if (info_response != null) {
                response = info_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (info_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return null;
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_INFO: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_INFO: name=[" + info_response.m_name + "]");
        System.out.println("NAMEWATCH_INFO: roid=[" + info_response.m_roid + "]");
        System.out.println("NAMEWATCH_INFO: registrant=[" + info_response.m_registrant + "]");
        System.out.println("NAMEWATCH_INFO: rptto.email=[" + info_response.m_rptto.m_email + "], rptto.freq=[" + EPPNamewatchBase.namewatchFreqToString(info_response.m_rptto.m_freq) + "]");
        System.out.println("NAMEWATCH_INFO: status {");
        for (int i = 0; i < info_response.m_status.length; ++i) {
            System.out.println("NAMEWATCH_INFO:   type=[" + EPPNamewatchBase.namewatchStatusToString(info_response.m_status[i].m_type) + "]");
            System.out.println("NAMEWATCH_INFO:   lang=[" + info_response.m_status[i].m_lang + "]");
            System.out.println("NAMEWATCH_INFO:   value=[" + info_response.m_status[i].m_value + "]");
        }
        System.out.println("NAMEWATCH_INFO: }");
        System.out.println("NAMEWATCH_INFO: clID=[" + info_response.m_client_id + "]");
        System.out.println("NAMEWATCH_INFO: crID=[" + info_response.m_created_by + "]");
        System.out.println("NAMEWATCH_INFO: crDate=[" + info_response.m_created_date + "]");
        System.out.println("NAMEWATCH_INFO: upID=[" + info_response.m_updated_by + "]");
        System.out.println("NAMEWATCH_INFO: upDate=[" + info_response.m_updated_date + "]");
        System.out.println("NAMEWATCH_INFO: exDate=[" + info_response.m_expiration_date + "]");
        System.out.println("NAMEWATCH_INFO: trDate=[" + info_response.m_transfer_date + "]");
        System.out.println("NAMEWATCH_INFO: end.");
        return info_response;
    }

    private static void namewatchDelete(String epp_client_id, String roid) {
        System.out.println("NAMEWATCH_DELETE: begin");
        epp_NamewatchDeleteReq delete_request = new epp_NamewatchDeleteReq();
        delete_request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        delete_request.m_roid = roid;
        System.out.println("NAMEWATCH_DELETE: Sending request");
        EPPNamewatchDelete namewatch_delete = new EPPNamewatchDelete();
        namewatch_delete.setRequestData(delete_request);
        epp_NamewatchDeleteRsp delete_response = null;
        epp_Response response = null;
        try {
            namewatch_delete = (EPPNamewatchDelete)epp_client.processAction((epp_Action)namewatch_delete);
            delete_response = namewatch_delete.getResponseData();
            if (delete_response != null) {
                response = delete_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (delete_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return;
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_DELETE: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_DELETE: end.");
    }

    private static void namewatchTransfer(String epp_client_id, String roid, epp_TransferOpType type, String password, int period) {
        System.out.println("NAMEWATCH_TRANSFER: begin");
        epp_NamewatchTransferReq request = new epp_NamewatchTransferReq();
        request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        request.m_roid = roid;
        if (period != 0) {
            request.m_period = NamewatchExample.createNamewatchPeriod(period);
        }
        request.m_trans = new epp_TransferRequest();
        request.m_trans.m_op = type;
        request.m_trans.m_auth_info = NamewatchExample.createPwAuthInfo(password);
        System.out.println("NAMEWATCH_RENEW: Sending request");
        EPPNamewatchTransfer command = new EPPNamewatchTransfer();
        command.setRequestData(request);
        epp_NamewatchTransferRsp request_response = null;
        epp_Response response = null;
        try {
            command = (EPPNamewatchTransfer)epp_client.processAction((epp_Action)command);
            request_response = command.getResponseData();
            if (request_response != null) {
                response = request_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (request_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return;
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_TRANSFER: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_TRANSFER: m_transfer_status=[" + EPPXMLBase.transferStatusToString((epp_TransferStatusType)request_response.m_transfer_status) + "]");
        System.out.println("NAMEWATCH_TRANSFER: end.");
    }

    private static void namewatchUpdateChange(String epp_client_id, String roid, String registrant, String rptTo, String frequency, String password) {
        System.out.println("NAMEWATCH_UPDATE(change): begin");
        epp_NamewatchUpdateReq request = new epp_NamewatchUpdateReq();
        request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        request.m_roid = roid;
        request.m_change = new epp_NamewatchUpdateChange();
        if (registrant != null) {
            request.m_change.m_registrant = registrant;
        }
        if (rptTo != null) {
            request.m_change.m_rptto = new epp_NamewatchRptTo(rptTo, EPPNamewatchBase.namewatchFreqFromString(frequency));
        }
        if (password != null) {
            request.m_change.m_auth_info = NamewatchExample.createPwAuthInfo(password);
        }
        System.out.println("NAMEWATCH_UPDATE(change): Sending request");
        EPPNamewatchUpdate command = new EPPNamewatchUpdate();
        command.setRequestData(request);
        epp_NamewatchUpdateRsp request_response = null;
        epp_Response response = null;
        try {
            command = (EPPNamewatchUpdate)epp_client.processAction((epp_Action)command);
            request_response = command.getResponseData();
            if (request_response != null) {
                response = request_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (request_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return;
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_UPDATE(change): m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_UPDATE(change): end.");
    }

    private static void namewatchUpdateAddRemove(String epp_client_id, String roid, boolean addRemove, String status, String lang, String reason) {
        System.out.println("NAMEWATCH_UPDATE(addRemove): begin");
        epp_NamewatchUpdateReq request = new epp_NamewatchUpdateReq();
        request.m_cmd = NamewatchExample.createCommand(epp_client_id);
        request.m_roid = roid;
        request.m_change = new epp_NamewatchUpdateChange();
        epp_NamewatchUpdateAddRemove update_type = new epp_NamewatchUpdateAddRemove();
        if (addRemove) {
            request.m_add = update_type;
        } else {
            request.m_remove = update_type;
        }
        update_type.m_status = new epp_NamewatchStatus[1];
        update_type.m_status[0] = new epp_NamewatchStatus();
        update_type.m_status[0].m_type = EPPNamewatchBase.namewatchStatusFromString(status);
        update_type.m_status[0].m_lang = lang;
        update_type.m_status[0].m_value = reason;
        System.out.println("NAMEWATCH_UPDATE(addRemove): Sending request");
        EPPNamewatchUpdate command = new EPPNamewatchUpdate();
        command.setRequestData(request);
        epp_NamewatchUpdateRsp request_response = null;
        epp_Response response = null;
        try {
            command = (EPPNamewatchUpdate)epp_client.processAction((epp_Action)command);
            request_response = command.getResponseData();
            if (request_response != null) {
                response = request_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (request_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return;
        }
        epp_Result[] results = response.m_results;
        System.out.println("NAMEWATCH_UPDATE(addRemove): m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("NAMEWATCH_UPDATE(addRemove): end.");
    }

    public static void main(String[] args) {
        System.out.println("Start of the Namewatch example");
        Object command_data = null;
        Object domain_auth_info = null;
        Object namewatch_exp_date = null;
        if (args.length < 5) {
            System.err.println(USAGE);
            System.exit(1);
        }
        RTKBase.setDebugLevel();
        String epp_host_name = args[0];
        String epp_host_port_string = args[1];
        String epp_client_id = args[2];
        String epp_password = args[3];
        String epp_namewatch_string = args[4];
        System.out.println("WARNING: Most of the tests marked [SHOULD_FAIL] will succeed in the .name OT&E playground, as the");
        System.out.println("         playground environment does not keep state of objects and only return example responses");
        System.out.println("         based on the data passed. The tests should give the expected result in the OT&E certification");
        System.out.println("         environment available from April 15th");
        if (!NamewatchExample.connect(epp_host_name, epp_host_port_string, epp_client_id, epp_password)) {
            System.err.println("Unable to connect to EPP server. Exiting");
            System.exit(1);
        }
        System.out.println("--- TEST 001 [SHOULD_SUCCEED]: Create namewatch. Requires the contact GNRVH1 to exist");
        String roid1 = NamewatchExample.namewatchCreate(epp_client_id, epp_namewatch_string, "GNRVH1", "test@nic.name", "weekly", 5, "abc123");
        System.out.println("--- TEST 002 [SHOULD_SUCCEED]: Register same string again. Namewatch allows duplicate registration, so this should succeed");
        String roid2 = NamewatchExample.namewatchCreate(epp_client_id, epp_namewatch_string, "GNRVH1", "test@nic.name", "weekly", 5, "abc123");
        System.out.println("--- TEST 003 [SHOULD_SUCCEED]: Request info for the returned roid");
        epp_NamewatchInfoRsp info1 = NamewatchExample.namewatchInfo(epp_client_id, roid1);
        System.out.println("--- TEST 004 [SHOULD_FAIL]: Request info for non-existant roid");
        NamewatchExample.namewatchInfo(epp_client_id, "thisRoidShouldNotExist-NAME");
        System.out.println("--- TEST 005 [SHOULD_SUCCEED]: Delete the second Namewatch registered");
        NamewatchExample.namewatchDelete(epp_client_id, roid2);
        System.out.println("--- TEST 006 [SHOULD_FAIL]: Request info for the just deleted Namewatch");
        NamewatchExample.namewatchInfo(epp_client_id, roid2);
        System.out.println("--- TEST 007 [SHOULD_SUCCEED]: Renew Namewatch for 1 year");
        NamewatchExample.namewatchRenew(epp_client_id, roid1, info1.m_expiration_date, 1);
        System.out.println("--- TEST 008 [SHOULD_SUCCEED]: Requesting transfer status. Should not show any transfer in progress");
        NamewatchExample.namewatchTransfer(epp_client_id, roid1, epp_TransferOpType.QUERY, "abc123", 0);
        System.out.println("--- TEST 009 [SHOULD_FAIL]: Approving transfer. Should fail as there is no transfer pending");
        NamewatchExample.namewatchTransfer(epp_client_id, roid1, epp_TransferOpType.APPROVE, "abc123", 0);
        System.out.println("--- TEST 009 [SHOULD_FAIL]: Rejecting transfer. Should fail as there is no transfer pending");
        NamewatchExample.namewatchTransfer(epp_client_id, roid1, epp_TransferOpType.APPROVE, "abc123", 0);
        System.out.println("--- TEST 009 [SHOULD_FAIL]: Requesting transfer. Should fail as we already own the object");
        NamewatchExample.namewatchTransfer(epp_client_id, roid1, epp_TransferOpType.REQUEST, "abc123", 1);
        System.out.println("--- TEST 010 [SHOULD_SUCCEED]: Changing e-mail reporting address for Namewatch");
        NamewatchExample.namewatchUpdateChange(epp_client_id, roid1, null, "reports@sometestcustomer.test", "weekly", null);
        System.out.println("--- TEST 011 [SHOULD_SUCCEED]: Requesting info");
        NamewatchExample.namewatchInfo(epp_client_id, roid1);
        System.out.println("--- TEST 012 [SHOULD_SUCCEED]: Adding a status");
        NamewatchExample.namewatchUpdateAddRemove(epp_client_id, roid1, true, "clientTransferProhibited", "en", "Customer has defaulted on payment");
        System.out.println("--- TEST 013 [SHOULD_SUCCEED]: Requesting info. Confirm that above status was added");
        NamewatchExample.namewatchInfo(epp_client_id, roid1);
        if (!NamewatchExample.disconnect(epp_client_id)) {
            System.err.println("Error during disconnect from EPP server. Exiting");
            System.exit(1);
        }
    }
}

