/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epp0503.example;

import com.gnr.rtk.addon.epp0503.EPPEmailFwdCreate;
import com.gnr.rtk.addon.epp0503.example.ContactExampleBase;
import com.gnr.rtk.addon.epp0503.example.EmailFwdExampleBase;
import com.gnr.rtk.addon.epp0503.extensions.EPPPersRegCreate;
import com.gnr.rtk.addon.epp0503.extensions.EPPPersRegInfo;
import com.gnr.rtk.addon.epp0503.extensions.EPPPersRegRenew;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContact;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdContactType;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdCreateReq;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdCreateRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdDeleteRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdInfoRsp;
import com.gnr.rtk.addon.epp0503.idl.emailfwd.epp_EmailFwdRenewRsp;
import com.gnr.rtk.addon.epp0503.idl.persreg.epp_PersRegCreateReq;
import com.tucows.oxrs.epp0503.rtk.RTKBase;
import org.openrtk.idl.epp0503.contact.epp_ContactAddress;
import org.openrtk.idl.epp0503.contact.epp_ContactCreateRsp;
import org.openrtk.idl.epp0503.contact.epp_ContactNameAddress;
import org.openrtk.idl.epp0503.contact.epp_ContactPhone;
import org.openrtk.idl.epp0503.epp_Result;
import org.openrtk.idl.epp0503.epp_XMLException;

public class PersRegExample
extends EmailFwdExampleBase {
    private static String USAGE = "Usage: com.gnr.rtk.addon.epp0503.example.PersRegExample epp_host_name epp_host_port epp_client_id epp_password emailfwd_string";

    public static epp_EmailFwdCreateRsp emailfwdCreate(String epp_client_id, String name, String fwdto, int period, String registrant, epp_EmailFwdContact[] contacts, String password) {
        System.out.println("EMAILFWD_CREATE: begin");
        epp_EmailFwdCreateReq create_request = new epp_EmailFwdCreateReq();
        create_request.m_cmd = PersRegExample.createCommand(epp_client_id);
        create_request.m_name = name;
        create_request.m_fwdto = fwdto;
        create_request.m_period = PersRegExample.createEmailFwdPeriod(period);
        create_request.m_registrant = registrant;
        create_request.m_contacts = contacts;
        create_request.m_auth_info = PersRegExample.createPwAuthInfo(password);
        EPPPersRegCreate persRegCreate = new EPPPersRegCreate();
        persRegCreate.setRequestData(new epp_PersRegCreateReq("consent-id-1"));
        create_request.m_cmd.m_extension = persRegCreate;
        System.out.println("EMAILFWD_CREATE: Sending registration for " + name);
        EPPEmailFwdCreate create = new EPPEmailFwdCreate();
        create.setRequestData(create_request);
        create = (EPPEmailFwdCreate)PersRegExample.processAction(create);
        if (create != null) {
            return create.getResponseData();
        }
        return null;
    }

    private static void emailfwdCreateTest(String epp_client_id, String name, String fwdto, int period, String registrant, epp_EmailFwdContact[] contacts, String password) {
        epp_EmailFwdCreateRsp rsp = PersRegExample.emailfwdCreate(epp_client_id, name, fwdto, period, registrant, contacts, password);
        if (rsp == null) {
            System.out.println("EMAILFWD_CREATE: NO RESPONSE FOUND");
            return;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_CREATE: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("EMAILFWD_CREATE: name=[" + rsp.m_name + "]");
        if (rsp.m_rsp.m_extension_string != null && !rsp.m_rsp.m_extension_string.equals("")) {
            EPPPersRegCreate persRegCreate = new EPPPersRegCreate();
            try {
                persRegCreate.fromXML(rsp.m_rsp.m_extension_string);
                System.out.println("EMAILFWD_CREATE: persRegCreate response [" + persRegCreate.getResponseData() + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
            }
        }
    }

    private static epp_EmailFwdInfoRsp emailfwdInfoTest(String epp_client_id, String name) {
        epp_EmailFwdInfoRsp rsp = PersRegExample.emailfwdInfo(epp_client_id, name);
        if (rsp == null) {
            System.out.println("EMAILFWD_INFO: NO RESPONSE FOUND");
            return null;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_INFO: code=[" + results[0].m_code + "] msg=[" + results[0].m_msg + "]");
        System.out.println("EMAILFWD_INFO: name=[" + rsp.m_name + "]");
        if (rsp.m_rsp.m_extension_string != null && !rsp.m_rsp.m_extension_string.equals("")) {
            EPPPersRegInfo persRegInfo = new EPPPersRegInfo();
            try {
                persRegInfo.fromXML(rsp.m_rsp.m_extension_string);
                System.out.println("EMAILFWD_INFO: persRegInfo response [" + persRegInfo.getResponseData() + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
            }
        }
        return rsp;
    }

    private static void emailfwdRenewTest(String epp_client_id, String name, String expirydate, int period) {
        epp_EmailFwdRenewRsp rsp = PersRegExample.emailfwdRenew(epp_client_id, name, expirydate, period);
        if (rsp == null) {
            System.out.println("EMAILFWD_RENEW: NO RESPONSE FOUND");
            return;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_RENEW: m_code=[" + results[0].m_code + "] m_msg=[" + results[0].m_msg + "]");
        System.out.println("EMAILFWD_RENEW: name=[" + rsp.m_name + "]");
        if (rsp.m_rsp.m_extension_string != null && !rsp.m_rsp.m_extension_string.equals("")) {
            EPPPersRegRenew persRegRenew = new EPPPersRegRenew();
            try {
                persRegRenew.fromXML(rsp.m_rsp.m_extension_string);
                System.out.println("EMAILFWD_RENEW: persRegRenew response [" + persRegRenew.getResponseData() + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
            }
        }
    }

    private static void emailfwdDeleteTest(String epp_client_id, String name) {
        epp_EmailFwdDeleteRsp rsp = PersRegExample.emailfwdDelete(epp_client_id, name);
        if (rsp == null) {
            System.out.println("EMAILFWD_DELETE: NO RESPONSE FOUND");
            return;
        }
        epp_Result[] results = rsp.m_rsp.m_results;
        System.out.println("EMAILFWD_DELETE: code=[" + results[0].m_code + "] msg=[" + results[0].m_msg + "]");
    }

    public static void main(String[] args) {
        System.out.println("Start of the EmailFwd example with the persReg Create extension");
        Object command_data = null;
        Object auth_info = null;
        Object exp_date = null;
        if (args.length < 5) {
            System.err.println(USAGE);
            System.exit(1);
        }
        RTKBase.setDebugLevel();
        String epp_host_name = args[0];
        String epp_host_port_string = args[1];
        String epp_client_id = args[2];
        String epp_password = args[3];
        String emailfwd = args[4];
        if (!PersRegExample.connect(epp_host_name, epp_host_port_string, epp_client_id, epp_password)) {
            System.err.println("Unable to connect to EPP server. Exiting");
            System.exit(1);
        }
        epp_ContactCreateRsp admin = null;
        epp_ContactCreateRsp tech = null;
        epp_ContactCreateRsp billing = null;
        epp_ContactCreateRsp registrant = null;
        epp_ContactNameAddress addr = null;
        addr = new epp_ContactNameAddress();
        addr.m_name = "Mr Registrant";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "High Street 57";
        addr.m_address.m_city = "Funnytown";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "fr";
        registrant = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("123", "+44.12345678"), new epp_ContactPhone(null, "+44.87654321"), "mycontactemail@somedomain.domain", "password");
        if (registrant != null) {
            System.out.println("Contact create (registrant): " + registrant.m_rsp.m_results[0].m_code);
        }
        addr = new epp_ContactNameAddress();
        addr.m_name = "John Doe";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "High Street 57";
        addr.m_address.m_city = "Funnytown";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "ch";
        admin = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("123", "+44.12345678"), new epp_ContactPhone(null, "+44.87654321"), "mycontactemail@somedomain.domain", "password");
        if (admin != null) {
            System.out.println("Contact create (admin): " + admin.m_rsp.m_results[0].m_code);
        }
        addr = new epp_ContactNameAddress();
        addr.m_name = "Foo Bar";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "High Street 55b";
        addr.m_address.m_city = "London";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "gb";
        tech = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("55", "+66.12345678"), new epp_ContactPhone(null, "+77.87654321"), "someother@somedomain.domain", "foobar");
        if (tech != null) {
            System.out.println("Contact create (tech): " + tech.m_rsp.m_results[0].m_code);
        }
        addr = new epp_ContactNameAddress();
        addr.m_name = "Iam A Bigshot";
        addr.m_org = "Some organization";
        addr.m_address = new epp_ContactAddress();
        addr.m_address.m_street1 = "Nowhere in particular";
        addr.m_address.m_city = "Outoftown";
        addr.m_address.m_postal_code = "12345";
        addr.m_address.m_country_code = "se";
        billing = ContactExampleBase.contactCreate(epp_client_id, addr, new epp_ContactPhone("22", "+55.55555555"), new epp_ContactPhone(null, "+22.22222222"), "email@somedomain.domain", "test");
        if (billing != null) {
            System.out.println("Contact create (billing): " + billing.m_rsp.m_results[0].m_code);
        }
        epp_EmailFwdContact[] contacts = new epp_EmailFwdContact[3];
        contacts[0] = new epp_EmailFwdContact();
        contacts[0].m_id = admin != null ? admin.m_id : "PHB";
        contacts[0].m_type = epp_EmailFwdContactType.ADMIN;
        contacts[1] = new epp_EmailFwdContact();
        contacts[1].m_id = tech != null ? tech.m_id : "GURU";
        contacts[1].m_type = epp_EmailFwdContactType.TECH;
        contacts[2] = new epp_EmailFwdContact();
        contacts[2].m_id = billing != null ? billing.m_id : "BEANCOUNTER";
        contacts[2].m_type = epp_EmailFwdContactType.BILLING;
        String registrant_id = registrant != null ? registrant.m_id : "MYCONTACTID-NAME";
        epp_EmailFwdInfoRsp info = null;
        PersRegExample.testHeader(1, true, "Create email forwarding object for 5 years with persRegCreate extension");
        PersRegExample.emailfwdCreateTest(epp_client_id, emailfwd, "mymailbox@mailboxes-r-us.mail", 5, registrant_id, contacts, "password");
        PersRegExample.testHeader(2, true, "Request information about email forwarding object expecting to see the consent id");
        info = PersRegExample.emailfwdInfoTest(epp_client_id, emailfwd);
        PersRegExample.testHeader(3, true, "Renew e-mail forwarding for 1 year expecting persRegRenew extension in the response");
        PersRegExample.emailfwdRenewTest(epp_client_id, emailfwd, info.m_expiration_date, 1);
        PersRegExample.testHeader(4, true, "Delete email forwarding object");
        PersRegExample.emailfwdDeleteTest(epp_client_id, emailfwd);
        if (!PersRegExample.disconnect(epp_client_id)) {
            System.err.println("Error during disconnect from EPP server. Exiting");
            System.exit(1);
        }
    }
}

