/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk;

import com.gnr.rtk.addon.epprtk.EPPDefRegBase;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegCheck;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegCheckReq;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegCheckRsp;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegNameType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_CheckResult;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDefRegCheck
extends EPPDefRegBase
implements epp_DefRegCheck {
    private epp_DefRegCheckReq action_request_;
    private epp_DefRegCheckRsp action_response_;

    public EPPDefRegCheck() {
    }

    public EPPDefRegCheck(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDefRegCheck(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_DefRegCheckReq value) {
        this.action_request_ = value;
    }

    public epp_DefRegCheckRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_names == null || this.action_request_.m_names.length == 0) {
            throw new epp_XMLException("missing request data");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element check = doc.createElement("check");
        epp_Command command_data = this.action_request_.m_cmd;
        Element defreg_check = doc.createElement("defReg:check");
        this.setCommonAttributes(defreg_check);
        List<epp_DefRegNameType> defreg_names = Arrays.asList(this.action_request_.m_names);
        Iterator<epp_DefRegNameType> it = defreg_names.iterator();
        while (it.hasNext()) {
            epp_DefRegNameType n = it.next();
            Element name_element = this.addXMLElement((Document)doc, defreg_check, "defReg:name", n.m_name);
            name_element.setAttribute("level", EPPDefRegCheck.defregLevelToString(n.m_level));
        }
        check.appendChild(defreg_check);
        command.appendChild(check);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DefRegCheckRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList defreg_check_result_list = response_data_element.getElementsByTagName("defReg:chkData").item(0).getChildNodes();
            this.debug(2, method_name, "defReg:chkData's node count [" + defreg_check_result_list.getLength() + "]");
            if (defreg_check_result_list.getLength() == 0) {
                throw new epp_XMLException("missing check results");
            }
            ArrayList<epp_CheckResult> check_list = new ArrayList<epp_CheckResult>();
            for (int count = 0; count < defreg_check_result_list.getLength(); ++count) {
                Node a_node = defreg_check_result_list.item(count);
                Element name_node = this.getElement(a_node.getChildNodes(), "defReg:name");
                epp_CheckResult check_result = new epp_CheckResult();
                check_result.m_value = name_node.getFirstChild().getNodeValue();
                check_result.m_avail = !name_node.getAttribute("avail").equals("0");
                this.debug(2, method_name, "m_value: [" + check_result.m_value + "]");
                check_list.add(check_result);
            }
            this.action_response_.m_results = (epp_CheckResult[])EPPDefRegCheck.convertListToArray(new epp_CheckResult().getClass(), check_list);
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

