/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk;

import com.gnr.rtk.addon.epprtk.EPPDefRegBase;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegCreate;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegCreateReq;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegCreateRsp;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegNameType;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegPeriod;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDefRegCreate
extends EPPDefRegBase
implements epp_DefRegCreate {
    private epp_DefRegCreateReq action_request_;
    private epp_DefRegCreateRsp action_response_;

    public EPPDefRegCreate() {
    }

    public EPPDefRegCreate(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDefRegCreate(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_DefRegCreateReq value) {
        this.action_request_ = value;
    }

    public epp_DefRegCreateRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML(EPPTransID)";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or DefReg name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element create = doc.createElement("create");
        epp_Command command_data = this.action_request_.m_cmd;
        Element DefReg_create = doc.createElement("defReg:create");
        this.setCommonAttributes(DefReg_create);
        epp_DefRegNameType defreg_name = this.action_request_.m_name;
        Element name_element = this.addXMLElement((Document)doc, DefReg_create, "defReg:name", defreg_name.m_name);
        name_element.setAttribute("level", EPPDefRegCreate.defregLevelToString(defreg_name.m_level));
        if (this.action_request_.m_registrant != null) {
            this.addXMLElement((Document)doc, DefReg_create, "defReg:registrant", this.action_request_.m_registrant);
        }
        if (this.action_request_.m_tm != null) {
            this.addXMLElement((Document)doc, DefReg_create, "defReg:tm", this.action_request_.m_tm);
        }
        if (this.action_request_.m_tmCountry != null) {
            this.addXMLElement((Document)doc, DefReg_create, "defReg:tmCountry", this.action_request_.m_tmCountry);
        }
        if (this.action_request_.m_tmDate != null) {
            this.addXMLElement((Document)doc, DefReg_create, "defReg:tmDate", this.action_request_.m_tmDate);
        }
        if (this.action_request_.m_adminContact != null) {
            this.addXMLElement((Document)doc, DefReg_create, "defReg:adminContact", this.action_request_.m_adminContact);
        }
        if (this.action_request_.m_period != null) {
            epp_DefRegPeriod DefReg_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, DefReg_create, "defReg:period", Short.toString(DefReg_period.m_value));
            period.setAttribute("unit", period_unit_to_string_array_[DefReg_period.m_unit.value()]);
        }
        if (this.action_request_.m_auth_info == null) {
            throw new epp_XMLException("missing auth info");
        }
        DefReg_create.appendChild(this.prepareAuthInfo((Document)doc, "defReg", this.action_request_.m_auth_info));
        create.appendChild(DefReg_create);
        command.appendChild(create);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DefRegCreateRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList DefReg_create_data_list = response_data_element.getElementsByTagName("defReg:creData").item(0).getChildNodes();
            this.debug(2, method_name, "defReg:creData's node count [" + DefReg_create_data_list.getLength() + "]");
            if (DefReg_create_data_list == null || DefReg_create_data_list.getLength() == 0) {
                throw new epp_XMLException("missing defReg create response data");
            }
            for (int count = 0; count < DefReg_create_data_list.getLength(); ++count) {
                Node a_node = DefReg_create_data_list.item(count);
                if (a_node.getNodeName().equals("defReg:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:name")) {
                    this.action_response_.m_name = new epp_DefRegNameType();
                    this.action_response_.m_name.m_name = a_node.getFirstChild().getNodeValue();
                    this.action_response_.m_name.m_level = EPPDefRegCreate.defregLevelFromString(((Element)a_node).getAttribute("level"));
                }
                if (a_node.getNodeName().equals("defReg:crDate")) {
                    this.action_response_.m_creation_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("defReg:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

