/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk;

import com.gnr.rtk.addon.epprtk.EPPDefRegBase;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegInfo;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegInfoReq;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegInfoRsp;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegNameType;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegStatus;
import com.gnr.rtk.addon.epprtk.idl.defreg.epp_DefRegStatusType;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_AuthInfo;
import org.openrtk.idl.epprtk.epp_AuthInfoType;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDefRegInfo
extends EPPDefRegBase
implements epp_DefRegInfo {
    private epp_DefRegInfoReq action_request_;
    private epp_DefRegInfoRsp action_response_;

    public EPPDefRegInfo() {
    }

    public EPPDefRegInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDefRegInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_DefRegInfoReq value) {
        this.action_request_ = value;
    }

    public epp_DefRegInfoRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_roid == null) {
            throw new epp_XMLException("missing request data or DefReg name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        Element DefReg_info = doc.createElement("defReg:info");
        this.setCommonAttributes(DefReg_info);
        this.addXMLElement((Document)doc, DefReg_info, "defReg:roid", this.action_request_.m_roid);
        if (this.action_request_.m_auth_info != null) {
            DefReg_info.appendChild(this.prepareAuthInfo((Document)doc, "defReg", this.action_request_.m_auth_info));
        }
        info.appendChild(DefReg_info);
        command.appendChild(info);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DefRegInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList DefReg_info_result_list = response_data_element.getElementsByTagName("defReg:infData").item(0).getChildNodes();
            this.debug(2, method_name, "defReg:infData's node count [" + DefReg_info_result_list.getLength() + "]");
            if (DefReg_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_DefRegStatus> statuses = new ArrayList<epp_DefRegStatus>();
            ArrayList contacts = new ArrayList();
            ArrayList name_servers = new ArrayList();
            ArrayList hosts = new ArrayList();
            for (int count = 0; count < DefReg_info_result_list.getLength(); ++count) {
                Node a_node = DefReg_info_result_list.item(count);
                if (a_node.getNodeName().equals("defReg:name")) {
                    this.action_response_.m_name = new epp_DefRegNameType();
                    this.action_response_.m_name.m_name = a_node.getFirstChild().getNodeValue();
                    this.action_response_.m_name.m_level = EPPDefRegInfo.defregLevelFromString(((Element)a_node).getAttribute("level"));
                }
                if (a_node.getNodeName().equals("defReg:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:registrant")) {
                    this.action_response_.m_registrant = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:tm")) {
                    this.action_response_.m_tm = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:tmCountry")) {
                    this.action_response_.m_tmCountry = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:tmDate")) {
                    this.action_response_.m_tmDate = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:adminContact")) {
                    this.action_response_.m_adminContact = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:status")) {
                    epp_DefRegStatus status = new epp_DefRegStatus();
                    Node status_value_node = a_node.getFirstChild();
                    if (status_value_node != null) {
                        status.m_value = status_value_node.getNodeValue();
                    }
                    status.m_lang = ((Element)a_node).getAttribute("lang");
                    if (!defreg_status_hash_.containsKey(((Element)a_node).getAttribute("s"))) {
                        status.m_value = "invalid DefReg status from server";
                        status.m_lang = "en";
                        status.m_type = null;
                    } else {
                        status.m_type = (epp_DefRegStatusType)defreg_status_hash_.get(((Element)a_node).getAttribute("s"));
                    }
                    statuses.add(status);
                }
                if (a_node.getNodeName().equals("defReg:clID")) {
                    this.action_response_.m_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:trDate")) {
                    this.action_response_.m_transfer_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("defReg:exDate")) {
                    this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("defReg:authInfo")) continue;
                this.action_response_.m_auth_info = new epp_AuthInfo();
                Node auth_info_child = a_node.getFirstChild();
                if (auth_info_child == null) {
                    throw new epp_XMLException("authInfo element missing sub-element");
                }
                this.action_response_.m_auth_info.m_value = auth_info_child.getFirstChild().getNodeValue();
                this.action_response_.m_auth_info.m_type = (epp_AuthInfoType)auth_type_string_to_type_hash_.get(((Element)auth_info_child).getLocalName());
                this.action_response_.m_auth_info.m_roid = ((Element)auth_info_child).getAttribute("roid");
            }
            if (statuses.size() > 0) {
                this.action_response_.m_status = (epp_DefRegStatus[])EPPDefRegInfo.convertListToArray(new epp_DefRegStatus().getClass(), statuses);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

