/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk;

import com.gnr.rtk.addon.epprtk.EPPEmailFwdBase;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdCheck;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdCheckReq;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdCheckRsp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_CheckResult;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPEmailFwdCheck
extends EPPEmailFwdBase
implements epp_EmailFwdCheck {
    private epp_EmailFwdCheckReq action_request_;
    private epp_EmailFwdCheckRsp action_response_;

    public EPPEmailFwdCheck() {
    }

    public EPPEmailFwdCheck(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPEmailFwdCheck(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_EmailFwdCheckReq value) {
        this.action_request_ = value;
    }

    public epp_EmailFwdCheckRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_names == null || this.action_request_.m_names.length == 0) {
            throw new epp_XMLException("missing request data");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element check = doc.createElement("check");
        epp_Command command_data = this.action_request_.m_cmd;
        Element emailfwd_check = doc.createElement("emailFwd:check");
        this.setCommonAttributes(emailfwd_check);
        List<String> emailfwd_names = Arrays.asList(this.action_request_.m_names);
        Iterator<String> it = emailfwd_names.iterator();
        while (it.hasNext()) {
            String emailfwd_name = it.next();
            this.addXMLElement((Document)doc, emailfwd_check, "emailFwd:name", emailfwd_name);
        }
        check.appendChild(emailfwd_check);
        command.appendChild(check);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_EmailFwdCheckRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList emailfwd_check_result_list = response_data_element.getElementsByTagName("emailFwd:chkData").item(0).getChildNodes();
            this.debug(2, method_name, "emailFwd:chkData's node count [" + emailfwd_check_result_list.getLength() + "]");
            if (emailfwd_check_result_list.getLength() == 0) {
                throw new epp_XMLException("missing check results");
            }
            ArrayList<epp_CheckResult> check_list = new ArrayList<epp_CheckResult>();
            for (int count = 0; count < emailfwd_check_result_list.getLength(); ++count) {
                Node a_node = emailfwd_check_result_list.item(count);
                Element name_node = this.getElement(a_node.getChildNodes(), "emailFwd:name");
                epp_CheckResult check_result = new epp_CheckResult();
                check_result.m_value = name_node.getFirstChild().getNodeValue();
                check_result.m_avail = !name_node.getAttribute("avail").equals("0");
                this.debug(2, method_name, "m_value: [" + check_result.m_value + "]");
                check_list.add(check_result);
            }
            this.action_response_.m_results = (epp_CheckResult[])EPPEmailFwdCheck.convertListToArray(new epp_CheckResult().getClass(), check_list);
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

