/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk;

import com.gnr.rtk.addon.epprtk.EPPEmailFwdBase;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdContact;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdContactType;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdInfo;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdInfoReq;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdInfoRsp;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdStatus;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdStatusType;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_AuthInfo;
import org.openrtk.idl.epprtk.epp_AuthInfoType;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPEmailFwdInfo
extends EPPEmailFwdBase
implements epp_EmailFwdInfo {
    private epp_EmailFwdInfoReq action_request_;
    private epp_EmailFwdInfoRsp action_response_;

    public EPPEmailFwdInfo() {
    }

    public EPPEmailFwdInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPEmailFwdInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_EmailFwdInfoReq value) {
        this.action_request_ = value;
    }

    public epp_EmailFwdInfoRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or emailfwd name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        Element emailfwd_info = doc.createElement("emailFwd:info");
        this.setCommonAttributes(emailfwd_info);
        this.addXMLElement((Document)doc, emailfwd_info, "emailFwd:name", this.action_request_.m_name);
        if (this.action_request_.m_auth_info != null) {
            emailfwd_info.appendChild(this.prepareAuthInfo((Document)doc, "emailFwd", this.action_request_.m_auth_info));
        }
        info.appendChild(emailfwd_info);
        command.appendChild(info);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_EmailFwdInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList emailfwd_info_result_list = response_data_element.getElementsByTagName("emailFwd:infData").item(0).getChildNodes();
            this.debug(2, method_name, "emailFwd:infData's node count [" + emailfwd_info_result_list.getLength() + "]");
            if (emailfwd_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_EmailFwdStatus> statuses = new ArrayList<epp_EmailFwdStatus>();
            ArrayList<epp_EmailFwdContact> contacts = new ArrayList<epp_EmailFwdContact>();
            ArrayList name_servers = new ArrayList();
            ArrayList hosts = new ArrayList();
            for (int count = 0; count < emailfwd_info_result_list.getLength(); ++count) {
                Node a_node = emailfwd_info_result_list.item(count);
                if (a_node.getNodeName().equals("emailFwd:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:registrant")) {
                    this.action_response_.m_registrant = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:contact")) {
                    epp_EmailFwdContact emailfwd_contact = new epp_EmailFwdContact();
                    emailfwd_contact.m_id = a_node.getFirstChild().getNodeValue();
                    emailfwd_contact.m_type = (epp_EmailFwdContactType)contact_type_hash_.get(((Element)a_node).getAttribute("type"));
                    contacts.add(emailfwd_contact);
                }
                if (a_node.getNodeName().equals("emailFwd:status")) {
                    epp_EmailFwdStatus status = new epp_EmailFwdStatus();
                    Node status_value_node = a_node.getFirstChild();
                    if (status_value_node != null) {
                        status.m_value = status_value_node.getNodeValue();
                    }
                    status.m_lang = ((Element)a_node).getAttribute("lang");
                    if (!emailfwd_status_hash_.containsKey(((Element)a_node).getAttribute("s"))) {
                        status.m_value = "invalid emailfwd status from server";
                        status.m_lang = "en";
                        status.m_type = null;
                    } else {
                        status.m_type = (epp_EmailFwdStatusType)emailfwd_status_hash_.get(((Element)a_node).getAttribute("s"));
                    }
                    statuses.add(status);
                }
                if (a_node.getNodeName().equals("emailFwd:fwdTo")) {
                    this.action_response_.m_fwdto = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:clID")) {
                    this.action_response_.m_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:trDate")) {
                    this.action_response_.m_transfer_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("emailFwd:exDate")) {
                    this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("emailFwd:authInfo")) continue;
                this.action_response_.m_auth_info = new epp_AuthInfo();
                Node auth_info_child = a_node.getFirstChild();
                if (auth_info_child == null) {
                    throw new epp_XMLException("authInfo element missing sub-element");
                }
                this.action_response_.m_auth_info.m_value = auth_info_child.getFirstChild().getNodeValue();
                this.action_response_.m_auth_info.m_type = (epp_AuthInfoType)auth_type_string_to_type_hash_.get(((Element)auth_info_child).getLocalName());
                this.action_response_.m_auth_info.m_roid = ((Element)auth_info_child).getAttribute("roid");
            }
            if (contacts.size() > 0) {
                this.action_response_.m_contacts = (epp_EmailFwdContact[])EPPEmailFwdInfo.convertListToArray(new epp_EmailFwdContact().getClass(), contacts);
            }
            if (statuses.size() > 0) {
                this.action_response_.m_status = (epp_EmailFwdStatus[])EPPEmailFwdInfo.convertListToArray(new epp_EmailFwdStatus().getClass(), statuses);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

