/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk;

import com.gnr.rtk.addon.epprtk.EPPEmailFwdBase;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdPeriod;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdRenew;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdRenewReq;
import com.gnr.rtk.addon.epprtk.idl.emailfwd.epp_EmailFwdRenewRsp;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epprtk.epp_Command;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPEmailFwdRenew
extends EPPEmailFwdBase
implements epp_EmailFwdRenew {
    private epp_EmailFwdRenewReq action_request_;
    private epp_EmailFwdRenewRsp action_response_;

    public EPPEmailFwdRenew() {
    }

    public EPPEmailFwdRenew(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPEmailFwdRenew(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    public void setRequestData(epp_EmailFwdRenewReq value) {
        this.action_request_ = value;
    }

    public epp_EmailFwdRenewRsp getResponseData() {
        return this.action_response_;
    }

    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or emailfwd name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element renew = doc.createElement("renew");
        epp_Command command_data = this.action_request_.m_cmd;
        Element emailfwd_renew = doc.createElement("emailFwd:renew");
        this.setCommonAttributes(emailfwd_renew);
        this.addXMLElement((Document)doc, emailfwd_renew, "emailFwd:name", this.action_request_.m_name);
        this.addXMLElement((Document)doc, emailfwd_renew, "emailFwd:curExpDate", this.action_request_.m_current_expiration_date);
        if (this.action_request_.m_period != null) {
            epp_EmailFwdPeriod emailfwd_period = this.action_request_.m_period;
            Element period = this.addXMLElement((Document)doc, emailfwd_renew, "emailFwd:period", Short.toString(emailfwd_period.m_value));
            period.setAttribute("unit", period_unit_to_string_array_[emailfwd_period.m_unit.value()]);
        }
        renew.appendChild(emailfwd_renew);
        command.appendChild(renew);
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_EmailFwdRenewRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList emailfwd_renew_data_list = response_data_element.getElementsByTagName("emailFwd:renData").item(0).getChildNodes();
            this.debug(2, method_name, "emailFwd:renData's node count [" + emailfwd_renew_data_list.getLength() + "]");
            if (emailfwd_renew_data_list == null || emailfwd_renew_data_list.getLength() == 0) {
                throw new epp_XMLException("missing emailfwd renew response data");
            }
            for (int count = 0; count < emailfwd_renew_data_list.getLength(); ++count) {
                Node a_node = emailfwd_renew_data_list.item(count);
                if (a_node.getNodeName().equals("emailFwd:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("emailFwd:exDate")) continue;
                this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

