/*
 * Decompiled with CFR 0.152.
 */
package com.gnr.rtk.addon.epprtk.example;

import com.gnr.rtk.addon.epprtk.EPPNamewatchBase;
import com.gnr.rtk.addon.epprtk.EPPNamewatchCreate;
import com.gnr.rtk.addon.epprtk.example.ExampleBase;
import com.gnr.rtk.addon.epprtk.idl.namewatch.epp_NamewatchCreateReq;
import com.gnr.rtk.addon.epprtk.idl.namewatch.epp_NamewatchCreateRsp;
import com.gnr.rtk.addon.epprtk.idl.namewatch.epp_NamewatchPeriod;
import com.gnr.rtk.addon.epprtk.idl.namewatch.epp_NamewatchPeriodUnitType;
import com.gnr.rtk.addon.epprtk.idl.namewatch.epp_NamewatchRptTo;
import com.tucows.oxrs.epprtk.rtk.RTKBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import org.openrtk.idl.epprtk.epp_Action;
import org.openrtk.idl.epprtk.epp_Exception;
import org.openrtk.idl.epprtk.epp_Response;
import org.openrtk.idl.epprtk.epp_Result;
import org.openrtk.idl.epprtk.epp_XMLException;

public class NamewatchBatchExample
extends ExampleBase {
    private static String USAGE = "Usage: com.gnr.rtk.addon.epprtk.example.NamewatchBatchExample epp_host_name epp_host_port epp_client_id epp_password namewatch_landrush_file";

    private static epp_NamewatchPeriod createNamewatchPeriod(int period) {
        epp_NamewatchPeriod p = new epp_NamewatchPeriod();
        p.m_unit = epp_NamewatchPeriodUnitType.YEAR;
        p.m_value = (short)period;
        return p;
    }

    private static epp_NamewatchCreateRsp namewatchCreate(String epp_client_id, String namewatch_string, String registrant, String rptto, String frequency, int period, String password) {
        System.out.println("NAMEWATCH_CREATE: begin");
        epp_NamewatchCreateReq create_request = new epp_NamewatchCreateReq();
        create_request.m_cmd = NamewatchBatchExample.createCommand(epp_client_id);
        create_request.m_name = namewatch_string;
        create_request.m_registrant = registrant;
        create_request.m_rptto = new epp_NamewatchRptTo(rptto, EPPNamewatchBase.namewatchFreqFromString(frequency));
        create_request.m_period = NamewatchBatchExample.createNamewatchPeriod(period);
        create_request.m_auth_info = NamewatchBatchExample.createPwAuthInfo(password);
        System.out.println("NAMEWATCH_CREATE: Sending registration");
        EPPNamewatchCreate namewatch_create = new EPPNamewatchCreate();
        namewatch_create.setRequestData(create_request);
        epp_NamewatchCreateRsp create_response = null;
        epp_Response response = null;
        try {
            namewatch_create = (EPPNamewatchCreate)epp_client.processAction((epp_Action)namewatch_create);
            create_response = namewatch_create.getResponseData();
            if (create_response != null) {
                response = create_response.m_rsp;
            }
        }
        catch (epp_XMLException xcp) {
            System.err.println("ERROR: epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("ERROR: epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("ERROR: Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
        if (create_response == null || response == null) {
            System.out.println("ERROR: No response found");
            return null;
        }
        return create_response;
    }

    public static void main(String[] args) {
        Object command_data = null;
        Object domain_auth_info = null;
        Object namewatch_exp_date = null;
        if (args.length < 5) {
            System.err.println(USAGE);
            System.exit(1);
        }
        RTKBase.setDebugLevel();
        String epp_host_name = args[0];
        String epp_host_port_string = args[1];
        String epp_client_id = args[2];
        String epp_password = args[3];
        String namewatch_file = args[4];
        if (!NamewatchBatchExample.connect(epp_host_name, epp_host_port_string, epp_client_id, epp_password)) {
            System.err.println("Unable to connect to EPP server. Exiting");
            System.exit(1);
        }
        try {
            File inputFile = new File(namewatch_file);
            BufferedReader inf = new BufferedReader(new FileReader(inputFile));
            File outputFile = new File(namewatch_file + ".result");
            PrintWriter outf = new PrintWriter(new FileWriter(outputFile));
            String buf = inf.readLine();
            System.out.println("Banner: '" + buf + "'");
            StreamTokenizer st = new StreamTokenizer(inf);
            st.quoteChar(34);
            st.eolIsSignificant(true);
            while (st.nextToken() != -1) {
                epp_NamewatchCreateRsp create_response;
                String transaction_id = st.sval;
                st.nextToken();
                String auth_info = st.sval;
                st.nextToken();
                String unique_identifier = st.sval;
                st.nextToken();
                String namewatch_string = st.sval;
                st.nextToken();
                String period = st.sval;
                st.nextToken();
                String registrant = st.sval;
                st.nextToken();
                String report_frequency = st.sval.toLowerCase();
                st.nextToken();
                String report_email = st.sval;
                if (st.nextToken() != 10) {
                    System.err.print("ERROR: Line contains too many fields: ");
                    System.err.println(st.lineno());
                }
                if ((create_response = NamewatchBatchExample.namewatchCreate(epp_client_id, namewatch_string, registrant, report_email, report_frequency, Integer.parseInt(period), auth_info)) != null) {
                    epp_Result[] results = create_response.m_rsp.m_results;
                    if (create_response.m_creation_date == null) {
                        create_response.m_creation_date = "0000-00-00";
                    }
                    outf.println("\"" + results[0].m_code + "\" \"" + unique_identifier + "\" \"" + create_response.m_roid + "\" \"" + transaction_id + "\" \"" + create_response.m_creation_date.substring(0, 10) + "\" \"" + create_response.m_expiration_date.substring(0, 10) + "\" \"" + results[0].m_msg + "\"");
                    continue;
                }
                System.err.println("ERROR: null response from namewatchCreate");
            }
            inf.close();
            outf.close();
        }
        catch (IOException io) {
            System.err.println("Error occured during processing. Aborting");
            System.err.println(io);
            NamewatchBatchExample.disconnect(epp_client_id);
            System.exit(1);
        }
        if (!NamewatchBatchExample.disconnect(epp_client_id)) {
            System.err.println("Error during disconnect from EPP server. Exiting");
            System.exit(1);
        }
    }
}

